#ifndef _RepIssues_Cpp
#define _RepIssues_Cpp
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Source/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/Replication.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/SplashDlg.H"
#include "../Dialogs/RepIssues.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND RepIssuesDlg_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK RepIssuesDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

	static HWND TablesList_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG)
    {
        RepIssuesDlg_hWnd = xHandle;

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_TRAYICON)) );

		LV_COLUMN MyLVColumb;
		memset(&MyLVColumb, 0, sizeof(MyLVColumb));

		TablesList_hWnd = GetDlgItem(xHandle, IDC_TALBES);

        int iLVStyle = LVS_EX_GRIDLINES;
        SendMessage(TablesList_hWnd, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)iLVStyle);

		// Create Listview columbs
        MyLVColumb.cx        = 300;
        MyLVColumb.pszText   = "Table Name";
        MyLVColumb.iSubItem  = 0;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(TablesList_hWnd, 0, &MyLVColumb);

        MyLVColumb.cx        = 150;
        MyLVColumb.pszText   = "Created Date";
        MyLVColumb.iSubItem  = 1;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(TablesList_hWnd, 1, &MyLVColumb);

		PopRepIssuesGrid(TablesList_hWnd);

		CenterWindow(xHandle);

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
        if(wParam == ID_CLOSE)
        {
			EndDialog(xHandle,0);
			DestroyWindow(xHandle);
			return TRUE;
        }
		
		return FALSE;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE) 
    {
        EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool PopRepIssuesGrid(HWND TablesList_hWnd)
{
	int iItem = 0;
	
	char sTemp[1024];
	int iTempSz = 0;

	CSQL cSQL;
	CRecordSet rsTemp;
	
	LV_ITEM MyLVItem;
	memset(&MyLVItem, 0, sizeof(MyLVItem));

	char *sSQL = "SELECT SysObjects.Name, SysObjects.CrDate"
		" FROM SysObjects"
		" WHERE SysObjects.xType = 'U'  AND LEFT(SysObjects.NAME, 8) <> 'SQLExch_'"
		" AND ID NOT IN (SELECT ID FROM SysColumns WHERE SysColumns.ColStat = 1)"
		" ORDER BY SysObjects.Name";
	
	if(!cSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, gsSQLDatabase))
	{
		MsgBox("Failed to connect to the SQL server.");
		return false;
	}

	cSQL.Execute(sSQL, &rsTemp);

	while(rsTemp.Fetch())
	{
		rsTemp.sColumnEx(1, sTemp, sizeof(sTemp), &iTempSz);
		MyLVItem.pszText = sTemp;
        MyLVItem.mask = LVIF_TEXT;
        MyLVItem.iSubItem = 0;
		MyLVItem.iItem = iItem;
        ListView_InsertItem(TablesList_hWnd, &MyLVItem);

		rsTemp.sColumnEx(2, sTemp, sizeof(sTemp), &iTempSz);
        MyLVItem.pszText = sTemp;
        MyLVItem.mask = LVIF_TEXT;
        MyLVItem.iSubItem = 1;
		MyLVItem.iItem = iItem;
        ListView_SetItem(TablesList_hWnd, &MyLVItem);

		iItem++;
	}

	cSQL.Disconnect();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

